/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSPort;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class WSService {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSService";
    private WSDefinition m_definition = null;
    private Service m_service = null;
    private WSPort[] m_ports = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                this.m_definition = null;
                this.m_service = null;
                if (this.m_ports != null) {
                    WSPort[] ports = this.m_ports;
                    this.m_ports = null;
                    for (int i = 0; i < ports.length; ++i) {
                        if (ports[i] == null) continue;
                        ports[i].releaseReferences();
                        ports[i] = null;
                    }
                    ports = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSService(WSDefinition definition, Service service) {
        this.m_definition = definition;
        this.m_service = service;
        if (service != null) {
            this.initPorts();
        }
    }

    private void initPorts() {
        Collection ports;
        Map portMap;
        if (this.m_service != null && (portMap = this.m_service.getPorts()) != null && (ports = portMap.values()) != null && ports.size() > 0) {
            this.m_ports = new WSPort[ports.size()];
            int i = 0;
            Iterator itPorts = ports.iterator();
            if (itPorts != null) {
                while (itPorts.hasNext()) {
                    Object obj = itPorts.next();
                    if (!(obj instanceof Port)) continue;
                    this.m_ports[i++] = new WSPort(this.m_definition, this, (Port)obj);
                }
            }
        }
    }

    public Service getService() {
        return this.m_service;
    }

    public WSPort[] getPorts() {
        return this.m_ports;
    }

    public QName getQName() {
        if (this.m_service != null) {
            return this.m_service.getQName();
        }
        return null;
    }

    public String getName() {
        if (this.m_service != null) {
            return this.m_service.getQName().getLocalPart();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_service != null) {
            return this.m_service.getQName().getLocalPart();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSameService(QName name) {
        QName qName;
        if (name != null && this.m_service != null && (qName = this.m_service.getQName()) != null) {
            return qName.equals(name);
        }
        return false;
    }

    public boolean isSameService(String name) {
        if (name != null && this.m_service != null) {
            QName aName = new QName(this.m_definition.getDefinition().getTargetNamespace(), name);
            return this.isSameService(aName);
        }
        return false;
    }

    public WSPort[] findSupportingPorts(String portTypeName) {
        if (portTypeName != null && this.m_ports != null && this.m_ports.length > 0) {
            Vector<WSPort> v = new Vector<WSPort>();
            for (int i = 0; i < this.m_ports.length; ++i) {
                if (this.m_ports[i] == null || !this.m_ports[i].isSupportingPortType(portTypeName)) continue;
                v.add(this.m_ports[i]);
            }
            if (v.size() > 0) {
                WSPort[] ports = new WSPort[v.size()];
                v.toArray(ports);
                v.removeAllElements();
                return ports;
            }
        }
        return null;
    }

    public WSPort getPort(String name) {
        if (name != null && this.m_ports != null) {
            for (int i = 0; i < this.m_ports.length; ++i) {
                if (this.m_ports[i] == null || !this.m_ports[i].isSamePort(name)) continue;
                return this.m_ports[i];
            }
        }
        return null;
    }
}

